<?php

namespace Import\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Import\ApiBundle\Entity\Interest;
use Import\ApiBundle\Entity\InvestmentFunds;

/**
 * InterestRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class InterestRepository extends EntityRepository
{
    /**
     * add new $Interest
     *
     * @param $data
     * @param bool $flush
     * @return Interest
     */
    public function add($data, $flush = false)
    {
        $Interest = new Interest();

        $Interest->setValue($data['Value']);
        $Interest->setDataFrom($data['DataFrom']);
        if(isset($data['DataTo']))
        {
            $Interest->setDataTo($data['DataTo']);
        }

        $this->getEntityManager()->persist($Interest);
        if($flush)
        {
            $this->getEntityManager()->flush();
        }

        return $Interest;
    }

    /**
     * get last Interest
     *
     * @return null|Interest
     */
    public function getLastInterest()
    {
        $QueryBuilder = $this->createQueryBuilder('i');
        $QueryBuilder
            ->select('i')
            ->orderBy('i.dataFrom','DESC')
            ->setMaxResults(1)
        ;

        return $QueryBuilder->getQuery()->getOneOrNullResult();
    }
}
